//	MainEvent.c
/*
	file originally named "DropShell"
*/

/******************************************************************************
**
**  Project Name:	DropShell
**     File Name:	DropShell.c
**
**   Description:	Main application code for the QuickShell
**
*******************************************************************************
**                       A U T H O R   I D E N T I T Y
*******************************************************************************
**
**	Initials	Name
**	--------	-----------------------------------------------
**	LDR			Leonard Rosenthol
**	MTC			Marshall Clow
**	SCS			Stephan Somogyi
**
*******************************************************************************
**                      R E V I S I O N   H I S T O R Y
*******************************************************************************
**
**	  Date		Author	Description
**	---------	------	---------------------------------------------
**	23 Jun	94	LDR		Implemented support for disk insertion events
**	02 Feb	94	LDR		Updated for Final SDK & CodeWarrior a2
**						Removed the ResumeProc as per new Apple recommendations
**	11 Dec 93	SCS		Universal Headers/UPPs (Phoenix 68k/PPC & PPCC)
**						Skipped System 6 compatible rev of DropShell source
**	09 Dec 91	LDR		Added support for new "Select File" menu item
**						Quit now sends AEVT to self to be politically correct
**						Added support for the new gSplashScreen
**	24 Nov 91	LDR		Added support for the Apple Menu (duh!)
**	29 Oct 91	SCS		Changes for THINK C 5
**	28 Oct 91	LDR		Officially renamed DropShell (from QuickShell)
**						Added a bunch of comments for clarification
**	06 Oct 91	MTC		Converted to MPW C
**	09 Apr 91	LDR		Added to Projector
**
******************************************************************************/

#ifndef __MWERKS__
	#include <Desk.h>
	#include <Dialogs.h>
	#include <Errors.h>
	#include <Files.h>
	#include <Fonts.h>
	#include <Memory.h>
	#include <Menus.h>
	#include <StandardFile.h>
	#include <TextEdit.h>
	#include <Types.h>
	#include <Windows.h>
#endif

#include "DSGlobals.h"
#include "DSUserProcs.h"
#include "DSAppleEvents.h"

#include "COutlineWindow.h"
#include "Utils.h"
#include "ADFS_Menus.h"
#include "CMDlgGetInfo.h"

#include "MainEvent.h"

Boolean		gDone, gOApped, gHasAppleEvents, gWasEvent;
EventRecord	gEvent;
WindowPtr	gSplashScreen;

#ifdef MPW
extern void _DataInit();	
#endif


#pragma segment Initialize
void InitToolbox (void) 
{

#ifdef MPW
	UnloadSeg ((Ptr) _DataInit );
#endif

	InitGraf ( &qd.thePort );
	InitFonts ();
	InitWindows ();
	InitMenus ();
	TEInit ();
	InitDialogs (0L);		// use of ResumeProcs no longer approved by Apple
	InitCursor ();
	FlushEvents ( everyEvent, 0 );
	
	// how about some memory fun! Two should be enough!
	MoreMasters ();
	MoreMasters ();
	}

/*
	Let's setup those global variables that the DropShell uses.
	
	If you add any globals for your own use,
	init them in the InitUserGlobals routine in DSUserProcs.c
*/
#pragma segment Initialize
Boolean InitGlobals (void) 
{
	long aLong;

	gDone			= false;
	gOApped			= false;	// probably not since users are supposed to DROP things!
	gHasAppleEvents	= Gestalt ( gestaltAppleEventsAttr, &aLong ) == noErr;
	gSplashScreen	= NULL;

	return(InitUserGlobals());	// call the user proc
}

/*
	This routine is called during startup to display a splash screen.
	
	This was recommend by the Blue Team HI person, John Sullivan, who
	feels that all apps should display something so that users can easily
	tell what is running, and be able to switch by clicking.  Thanks John!
*/
#pragma segment Initialize
void InstallSplashScreen(void) 
{
}


/*	--------------- Standard Event Handling routines ---------------------- */
#pragma segment Main
void ShowAbout(void);
void ShowAbout(void) 
{
	Alert(128, NULL);
}


Boolean		gDoubleClick	= FALSE;
long		prevEventWhen	= 0;

void DoMouseDown (EventRecord *event)
{
}

#pragma segment Main
void DoKeyDown ( EventRecord *curEvent )
{
}

static	Boolean		IdleCB(CWindow *window, void *data)
{
	return FALSE;
}

static	void	Idle(void)
{
}

enum {
	idleEvt = 16, 
	suspendEvt, 
	suspendNoConvEvt, 
	resumeEvt, 
	resumeNoConvEvt, 
	mouseMovedEvt, 
	highLevelEvt = kHighLevelEvent
};

#define	GetOSEvtType(message)	(((message) & osEvtMessageMask) >> 24)
#define	IsResume(message)		(((message) & resumeFlag) != 0)
#define	DontConvert(message)	(((message) & convertClipboardFlag) != 0)

static	short	OSEvtType(EventRecord *theEvent)
{
	short	event	= nullEvent;
		
	return event;
}

static	void	HandleEvent(EventRecord *theEvent)
{
}

#pragma segment Main
void main ( ) 
{
	InitToolbox ();

	if (InitGlobals()) {	// if we succeeding in initting self
		DisposeUserGlobals();	// call the userproc to clean itself up
	}
}
